
#include "TimeUtils.h"

#include "Blinky.h"


BlinkyCls::BlinkyCls(uint8_t pin, bool invert, uint16_t period) :
  _Pin(pin),
  _Invert(invert),
  _Period(period),
  _Time(millis()),
  _State(false)
{

}


bool BlinkyCls::Toggle() 
{
  if (timeCheck(&_Time, _Period))
  {
    if (!_Invert)
    {
      digitalWrite(_Pin, _State);
    }
    else
    {
      if (_State) 
      {
        pinMode(_Pin, OUTPUT);
        digitalWrite(_Pin, LOW); 
      }
      else 
      {
        pinMode(_Pin, INPUT);
      }
    }
    _State = !_State;
	return true;
  }
  return false;
}

void BlinkyCls::SetPeriod(uint16_t period)
{
  _Period = period;
}
