
#include "TimeUtils.h"
#include "Button.h"

ButtonCls::ButtonCls(uint8_t pin) :
	State(false),  
	Change(false),
	_Pin(pin),
	_Debounce(millis()),
	_Time(millis())
{
	pinMode(_Pin, INPUT_PULLUP);
}


bool ButtonCls::Scan() 
{
	const uint8_t newval = !digitalRead(_Pin); // active low -> invert to high.
	
	if (timeCheckNoUpdate(_Debounce, 50)) //debounce timer
	{
		Change = newval != State;
		if (Change) 
		{
			State = newval;
			if (State)
			{
				_Time = millis();
			}
			_Debounce = millis();
			return true;
		}
	}
	return false;
}

uint32_t ButtonCls::GetTime() const
{
	return millis() - _Time;
}
