
#include <avr/pgmspace.h>

#include "TimeUtils.h"
#include "Encoder.h"


#ifdef USE_TABLE 
	const int8_t EncoderCls::_Table[16] __attribute__((__progmem__)) = { 0, 0, -1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, -1, 0, 0 };  // half resolution
	//const int8_t EncoderCls::_Table[16] __attribute__((__progmem__)) = { 0, 1, -1, 0, -1, 0, 0, 1, 1, 0, 0, -1, 0, -1, 1, 0 };  // full resolution  
#endif

EncoderCls::EncoderCls(uint8_t pin_a, uint8_t pin_b) :
	Value(0),
	Delta(0),
	_PinA(pin_a), 
	_PinB(pin_b),
	_Last(0),
	_Time(millis())
{
	pinMode(_PinA, INPUT_PULLUP);
	pinMode(_PinB, INPUT_PULLUP);

	if (!digitalRead(_PinA)) 
		_Last = 3;

	if (!digitalRead(_PinB)) 
		_Last ^=1;
}

int8_t EncoderCls::Scan()
{
	int8_t delta = 0;
	
	if (timeCheck(&_Time, 1))
	{
#ifdef USE_TABLE
		_Last = (_Last << 2) & 0x0F;

		if (!digitalRead(_PinA)) 
			_Last |= 2;

		if (!digitalRead(_PinB)) 
			_Last |= 1;

		delta = pgm_read_byte(&_Table[_Last]); 
#else
		int8_t curr = 0;
		if (!digitalRead(_PinA)) 
			curr = 3;

		if (!digitalRead(_PinB)) 
			curr ^= 1;
  
		int8_t diff = _Last - curr;
		if (diff & 1)  // bit 0 = step
		{           
			_Last = curr;
			delta = (diff & 2) - 1; // bit 1 = direction (+/-)
		}
#endif

		Delta += delta;
		Value += delta;
	}
	return delta;
}
