
#ifndef __Encoder_h__
#define __Encoder_h__

#include <stdint.h>
#include "Arduino.h"

// http://www.mikrocontroller.net/articles/Drehgeber

#define USE_TABLE

class EncoderCls
{

public:
	EncoderCls(uint8_t pin_a, uint8_t pin_b);

	int8_t Scan();

	volatile int16_t Value;
	volatile int16_t Delta;

private:
	const uint8_t _PinA;
	const uint8_t _PinB;
  
	volatile int16_t _Last;
	uint32_t _Time;
    
#ifdef USE_TABLE
	static const int8_t _Table[16];
#endif
};


#endif 
