
#ifndef __SimpleHID_h__
#define __SimpleHID_h__

#include <stdlib.h>
#include <stdint.h>

#include <Arduino.h>
#include <HID.h>


#define REPORT_IN_COUNT		16		//length send to computer
#define REPORT_OUT_COUNT	4		//length received from computer

#ifndef USB_EP_SIZE
#define USB_EP_SIZE			64
#endif


#ifndef TRANSFER_PGM
#define TRANSFER_PGM		0x80
#endif

#ifndef TRANSFER_RELEASE
#define TRANSFER_RELEASE	0x40
#endif

#ifndef TRANSFER_ZERO
#define TRANSFER_ZERO		0x20
#endif



// HID Keyboard/Mouse bios compatible protocols HID1.11 Page 9 4.3 Protocols
#ifndef HID_PROTOCOL_NONE
#define HID_PROTOCOL_NONE 0
#endif

#ifndef HID_PROTOCOL_KEYBOARD
#define HID_PROTOCOL_KEYBOARD 1
#endif

#ifndef HID_PROTOCOL_MOUSE
#define HID_PROTOCOL_MOUSE 2
#endif

// Normal or bios protocol (Keyboard/Mouse) HID1.11 Page 54 7.2.5 Get_Protocol Request
// "protocol" variable is used for this purpose.
#ifndef HID_BOOT_PROTOCOL
#define HID_BOOT_PROTOCOL	0
#endif

#ifndef HID_REPORT_PROTOCOL
#define HID_REPORT_PROTOCOL	1
#endif


// HID Request Type HID1.11 Page 51 7.2.1 Get_Report Request
#ifndef HID_REPORT_TYPE_INPUT
#define HID_REPORT_TYPE_INPUT   1
#endif

#ifndef HID_REPORT_TYPE_OUTPUT
#define HID_REPORT_TYPE_OUTPUT  2
#endif

#ifndef HID_REPORT_TYPE_FEATURE
#define HID_REPORT_TYPE_FEATURE 3
#endif


typedef void (*USBRecvCallback)(uint8_t *data, size_t datalen);


class SimpleHIDCls : public PluggableUSBModule
{
public:
	SimpleHIDCls(void);

	void SetRecvDataCB(USBRecvCallback cb, uint8_t* data, size_t datalen)
	{
		_Data = (uint8_t*)data;
		_DataLen = datalen;
		_RecvDataCB = cb;
	}
  
	void SetRecvFeatureCB(USBRecvCallback cb, uint8_t* feat, size_t featlen)
	{
		_Feature = (uint8_t*)feat;
		_FeatureLen = featlen;
		_RecvFeatureCB = cb;
	}

	size_t USBSend(uint8_t *data, size_t datalen)
	{
#ifdef ARDUINO_SAM_DUE
		return USBD_Send(pluggedEndpoint | TRANSFER_RELEASE, data, datalen);
#else
		return USB_Send(pluggedEndpoint | TRANSFER_RELEASE, data, datalen);
#endif
	}

protected:
	//PluggableUSBModule
	virtual int getInterface(uint8_t* interfaceCount) override;
	virtual int getDescriptor(USBSetup& setup) override;
	virtual bool setup(USBSetup& setup) override;

#ifdef ARDUINO_SAM_DUE
	uint32_t epType[1]; // platform dependant!!!
#else
	uint8_t epType[1]; // platform dependant!!! 
#endif

    
	uint8_t _Protocol;
	uint8_t _Idle;


	USBRecvCallback _RecvDataCB;
	uint8_t* _Data;
	uint16_t _DataLen;

	USBRecvCallback _RecvFeatureCB;
	uint8_t* _Feature;
	int _FeatureLen;
};

#endif


