
#ifndef __TimeUtils_h__
#define __TimeUtils_h__

#include <stdint.h>
#include <Arduino.h>


static bool timeCheck(uint32_t* last, uint32_t delay)
{
  uint32_t time = millis();
  
  if (time >= *last)
  {
    if ((time - *last) >= delay) 
    {
      *last = time;
      return true;
    }
  }
  else
  {
    if ((0xFFFFFFFF - (*last - time)) >= delay)
    {
      *last = time;
      return true;
    }
  } 
  return false;
}

static bool timeCheckNoUpdate(uint32_t last, uint32_t delay)
{
  uint32_t time = millis();
  
  if (time >= last)
  {
    if ((time - last) >= delay) 
    {
      return true;
    }
  }
  else
  {
    if ((0xFFFFFFFF - (last - time)) >= delay)
    {
      return true;
    }
  } 
  return false;
}




static bool timeCheckHP(uint32_t* last, uint32_t delay)
{
  uint32_t time = micros();
  
  if (time >= *last)
  {
    if ((time - *last) >= delay) 
    {
      *last = time;
      return true;
    }
  }
  else
  {
    if ((0xFFFFFFFF - (*last - time)) >= delay)
    {
      *last = time;
      return true;
    }
  } 
  return false;
}

static bool timeCheckNoUpdateHP(uint32_t last, uint32_t delay)
{
  uint32_t time = micros();
  
  if (time >= last)
  {
    if ((time - last) >= delay) 
    {
      return true;
    }
  }
  else
  {
    if ((0xFFFFFFFF - (last - time)) >= delay)
    {
      return true;
    }
  } 
  return false;
}

#endif 
