
#ifdef DEBUG
#include <PrintEx.h>
PrintEx serial = Serial;
#endif

#include "TimeUtils.h"

#include "Blinky.h"
#include "Button.h"
#include "Encoder.h"
#include "MyHID.h"

#include "main.h"

//blinking LED
BlinkyCls Blinky(PIN_LED, PIN_LED_INVERT, 500);

//Btn
ButtonCls Btn01(PIN_BTN1);
ButtonCls Btn02(PIN_BTN2);
ButtonCls Btn03(PIN_BTN3);

//Encoder
EncoderCls Enc(PIN_ENCA, PIN_ENCB);

//HID
static uint16_t blinkyCmd = 0;
static size_t blinkyCmdLen = 0;

static void _DataCB(uint8_t *data, size_t datalen)
{
	uint8_t cmdId = data[0];

	switch (cmdId)
	{
		case 1:
		{
			blinkyCmd = *(uint16_t*)&data[1];
			blinkyCmdLen = datalen;
			break;
		}
	}
}
MyHIDCls MyHID(_DataCB, nullptr);



///////////////
void setup() 
{
#ifdef DEBUG
	Serial.begin (115200);
#endif
}

void loop() 
{
	Blinky.Toggle();
	
	if (blinkyCmdLen)
	{
#ifdef DEBUG
		serial.printf("Blinky(%d): %d\n", blinkyCmdLen, blinkyCmd);
#endif		
		if (blinkyCmd > 10)
			Blinky.SetPeriod(blinkyCmd);
		blinkyCmdLen = 0;
	}
  
	Enc.Scan();
  

	if (Btn01.Scan())
	{	
		MyHID.ForceModified();
#ifdef DEBUG
		serial.printf("Btn01: %d, %d\n", Btn01.State, Btn01.GetTime());
#endif
	}
	if (Btn02.Scan())
	{
		MyHID.ForceModified();
#ifdef DEBUG
		serial.printf("Btn02: %d, %d\n", Btn02.State, Btn02.GetTime());
#endif
	}
	if (Btn03.Scan()) 
	{
		MyHID.ForceModified();
		Enc.Delta = -Enc.Value;
		Enc.Value = 0;
#ifdef DEBUG
		serial.printf("Btn03: %d, %d\n", Btn03.State, Btn03.GetTime());
#endif
	}
	if (Enc.Delta != 0)
	{
		MyHID.ForceModified();
#ifdef DEBUG
		serial.printf("Enc: %d, %d\n", Enc.Value, Enc.Delta);
#endif
	}
	
	MyHID.SetData8(0, Btn01.State, false);
	MyHID.SetData8(1, Btn01.Change, false);
	MyHID.SetData16(2, Btn01.GetTime(), false);
		
	MyHID.SetData8(4, Btn02.State, false);
	MyHID.SetData8(5, Btn02.Change, false);
	MyHID.SetData16(6, Btn02.GetTime(), false);
		
	MyHID.SetData8(8, Btn03.State, false);
	MyHID.SetData8(9, Btn03.Change, false);
	MyHID.SetData16(10, Btn03.GetTime(), false);
		
	MyHID.SetData16(12, Enc.Value, false);
	MyHID.SetData16(14, Enc.Delta, false); 

  
	if (MyHID.Send())
	{
		MyHID.SetData8(1, 0, false); // Clear btn01 change
		MyHID.SetData8(3, 0, false); // Clear btn02 change
		MyHID.SetData8(5, 0, false); // Clear btn03 change
		MyHID.SetData8(7, 0, false); // Clear btn04 change
	
		Enc.Delta = 0;
	}


}


